#!/usr/bin/python

# this demo needs buddha model from
# http://graphics.stanford.edu/data/3Dscanrep/

import sys
sys.path.append(open('ModulePath').read().strip())

from raytracer import Raytracer, Light, Sphere, Triangle, Material
from plyreader import LoadStanfordPlyFile
import Image

rt = Raytracer()
mat = Material(colour=(0.9, 0.9, 0.9))
LoadStanfordPlyFile(rt, "../models/happy/happy_vrip_res2.ply",
	mat, smooth=True, scale=20.0, trans=(0,-3,0))

light = Light(position=(-5.0, 2.0, 8.0), colour=(0.9, 0.3, 0.6))
rt.addlight(light)

imagesize = (800, 600)
data = rt.render(imagesize)
img = Image.fromstring("RGB", imagesize, data)
img.save('buddha.png')
