#!/usr/bin/python

import sys
sys.path.append(open('ModulePath').read().strip())

from raytracer import Raytracer, Light, Sphere, Triangle, NormalVertex, Material
from objreader import LoadWavefrontObjFile
import Image

rt = Raytracer()
mat = Material(colour=(0.9, 0.9, 0.9))
LoadWavefrontObjFile(rt, "monkey.obj", mat, 1.5)

light = Light(position=(-5.0, 2.0, 8.0), colour=(0.9, 0.3, 0.6))
rt.addlight(light)

imagesize = (800, 600)
data = rt.render(imagesize)
img = Image.fromstring("RGB", imagesize, data)
img.save('triangles_monkey.png')
