/*
 * Pyrit Ray Tracer
 * file: quaternion.h
 *
 * Radek Brich, 2006-2007
 */

#ifndef QUATERNION_H
#define QUATER_H

class Quaternion
{
public:
	union {
		struct {
			Float a,b,c,d;
		};
		struct {
			Float t,x,y,z;
		};
	};
	Quaternion(): a(0), b(0), c(0), d(0) {};
	Quaternion(const Float aa, const Float ab, const Float ac, const Float ad):
		a(aa), b(ab), c(ac), d(ad) {};
	Quaternion(const Vector3& v): a(1), b(v.x), c(v.y), d(v.z) {};

	Vector3 toVector() { return Vector3(b/a, c/a, d/a); };

	Quaternion normalize()
	{
		Float f = 1.0f / sqrtf(a * a + b * b + c * c + d * d);
		a *= f;
		b *= f;
		c *= f;
		d *= f;
		return *this;
	};
	Float mag2() const
	{
		return (a*a + b*b + c*c + d*d);
	};
	Float mag() const
	{
		return sqrtf(mag());
	};
	friend Quaternion operator*(const Quaternion &q1, const Quaternion &q2)
	{
		return Quaternion(
			q1.a*q2.a - q1.b*q2.b - q1.c*q2.c - q1.d*q2.d,
			q1.a*q2.b + q1.b*q2.a + q1.c*q2.d - q1.d*q2.c,
			q1.a*q2.c - q1.b*q2.d + q1.c*q2.a + q1.d*q2.b,
			q1.a*q2.d + q1.b*q2.c - q1.c*q2.b + q1.d*q2.a);
	};
	friend Float dot(const Quaternion &q1, const Quaternion &q2)
	{
		return q1.a*q2.a + q1.b*q2.b + q1.c*q2.c + q1.d*q2.d;
	};
	friend Quaternion conjugate(const Quaternion &q)
	{
		return Quaternion(q.a, -q.b, -q.c, -q.d);
	};
};

#endif
