/*
 * Pyrit Ray Tracer
 * file: raytracer.h
 *
 * Radek Brich, 2006-2007
 */

#ifndef RAYTRACER_H
#define RAYTRACER_H

#include <vector>

#include "common.h"
#include "container.h"
#include "scene.h"

using namespace std;

class Raytracer;
struct RenderrowData {
	Raytracer *rt;
	int w;
	Vector3 eye, dfix, dx, dy;
	Float *iter;
};

class Raytracer
{
	Container *top;
	Camera *camera;
	vector<Light*> lights;
	Colour bg_colour;
	int ao_samples;
	Float ao_distance, ao_angle;
	int num_threads;
	int subsample;
	int oversample; // 0 = no, 1 = 5x, 2 = 9x, 3 = 16x
	int max_depth;

	Vector3 SphereDistribute(int i, int n, Float extent, Vector3 &normal);
public:
	Raytracer(): top(NULL), camera(NULL), lights(), bg_colour(0.0, 0.0, 0.0),
		ao_samples(0), num_threads(2), subsample(8), oversample(0), max_depth(3) {};
	void render(int w, int h, Float *buffer);
	Colour raytrace(Ray &ray, int depth, Shape *origin_shape);
	void addshape(Shape *shape) { top->addShape(shape); };
	void addlight(Light *light);
	void setCamera(Camera *cam) { camera = cam; };
	void setTop(Container *atop) { top = atop; };
	Container *getTop() { return top; };
	void setSubsample(int sub) { subsample = sub; };
	int getSubsample() { return subsample; };
	void setOversample(int osa) { oversample = osa; };
	int getOversample() { return oversample; };
	void setMaxDepth(int newdepth) { max_depth = newdepth; };

	void ambientocclusion(int samples, Float distance, Float angle);
	void setThreads(int num) { num_threads = num; };
};

#endif
