#!/usr/bin/python

from pyrit import *
from lworeader import LoadLightwaveLwoFile
from math import *

rt = Raytracer()
top = KdTree()
rt.setTop(top)
rt.setBgColour((0.2,0.3,0.8))
cam = Camera(eye=(-5,3,5),lookat=(-1,1.5,0))
rotx=0.15
cam.rotate((cos(rotx),-sin(rotx),0.,0.))
rt.setCamera(cam)

LoadLightwaveLwoFile(rt, "../models/lwo/Nissan300ZX.lwo", scale=0.4)

mat = Material(colour=(0.5, 0.5, 0.5))
ground = Box(L=(-10,-2,-10), H=(10,-1.2,10), material=mat)
rt.addShape(ground)

wall = Box(L=(-10,-2,-4), H=(10,10,-3), material=mat)
rt.addShape(wall)

light1 = Light(position=(-5.0, 20.0, 8.0), colour=(0.9, 0.9, 0.9))
rt.addLight(light1)
light2 = Light(position=(5.0, 10.0, 10.0), colour=(0.9, 0.7, 0.7))
rt.addLight(light2)

top.optimize()

sampler = DefaultSampler(800, 600)
sampler.setOversample(2)
rt.setSampler(sampler)
rt.render()
sampler.getPixmap().writePNG('car.png')
