#!/usr/bin/python

# this demo needs bunny model from
# http://graphics.stanford.edu/data/3Dscanrep/

from pyrit import *
from plyreader import LoadStanfordPlyFile

rt = Raytracer()
top = KdTree()
rt.setTop(top)
rt.setCamera(Camera(eye=(4,2,3.5),lookat=(0.5,0.5,-3)))
rt.setBgColour((0.5, 0.5, 0.2))

mat = Material(colour=(0.4, 0.5, 0.9))
mat.setTransmissivity(0.95, 1.5)
mat.setReflectivity(0)
mat.setSmooth(True)
LoadStanfordPlyFile(rt, "../models/ply/bunny/bun_zipper.ply",
	mat, scale=(-29.0, 29.0, 29.0), trans=(-1,-2.5,-3))

mat0 = Material(colour=(0.3, 0.5, 1.0))
floor = Box(L=(-20.0, -1.7, -20.0), H=(20.0, -1.5, 20.0), material=mat0)
rt.addShape(floor)

mat1 = Material(colour=(0.5, 0.5, 0.2))
mat1.setReflectivity(0.0)
wall = Box(L=(-20.0, -20.0, -10.0), H=(20.0, 20.0, -12.0), material=mat1)
rt.addShape(wall)

light = Light(position=(-5.0, 3.0, 10.0), colour=(0.8, 0.5, 0.6))
rt.addLight(light)

light2 = Light(position=(4.0, 1.0, 10.0), colour=(0.5, 0.55, 0.7))
rt.addLight(light2)

top.optimize()

sampler = DefaultSampler(800, 600)
sampler.setOversample(1)
rt.setSampler(sampler)
rt.render()
sampler.getPixmap().writePNG('bunny.png')
