#!/usr/bin/python

from pyrit import *

rt = Raytracer()
top = KdTree()
rt.setTop(top)
rt.setCamera(Camera(eye=(10,4,-6),lookat=(10,3.5,0)))

light1 = Light(position=(10.0, 7.0, 3.0), colour=(0.9, 0.3, 0.6))
rt.addLight(light1)

light2 = Light(position=(8.0, 5.0, 1.0), colour=(0.7, 1.0, 0.3))
rt.addLight(light2)

light3 = Light(position=(12.0, 8.0, -1.0), colour=(0.8, 0.9, 1.0))
rt.addLight(light3)

mat0 = Material(colour=(0.1, 0.2, 0.9))
mat0.setReflectivity(0.0)
box = Box(L=(-10.0, 0.0, 50.0), H=(30.0, 1.0, -1.0), material=mat0)
rt.addShape(box)

mat1 = Material(colour=(1.0, 0.2, 0.1))
mat1.setReflectivity(0.7)
bigsphere = Sphere(centre=(12.0, 4.0, 6.0), radius=2.5, material=mat1)
rt.addShape(bigsphere)

mat2 = Material(colour=(0.1, 0.4, 0.2))
mat2.setReflectivity(0.6)
smallsphere = Sphere(centre=(6.5, 3.5, 8.0), radius=2.0, material=mat2)
rt.addShape(smallsphere)

mat3 = Material(colour=(0.9, 0.9, 1.0))
mat3.setPhong(0.2, 1.0, 0.2)
mat3.setTransmissivity(0.88)
mat3.setReflectivity(0.1)
for i in range(10):
	sph = Sphere(centre=(5.0+i, 1.5, 4.0), radius=0.5, material=mat3)
	rt.addShape(sph)

top.optimize()

sampler = DefaultSampler(800, 600)
rt.setSampler(sampler)
rt.render()
sampler.getPixmap().writePNG('spheres_glass.png')
