#ifndef KDTREE_H
#define KDTREE_H

#include <vector>

#include "scene.h"

class SpaceDivider
{
	ShapeList *shapes;
public:
	SpaceDivider(ShapeList &shapelist): shapes(shapelist) {};
};

class KdNode:
{
	float split;
	bool leaf; /* is this node a leaf? */
	char axis; /* 0,1,2 => x,y,z */
	KdNode *leftchild, *rightchild;
public:
	vector<Shape*> shapes;

	KdNode() : leaf(true), axis(0), shapes() {};

	setAxis(char aAxis) { axis = aAxis; };
	char getAxis() { return axis; };

	setSplit(float aSplit) { split = aSplit; };
	float getSplit() { return split; };

	setLeaf(bool aLeaf) { leaf = aLeaf; };
	bool isLeaf() { return leaf; };

	setLeftChild(KdNode *aLeft) { leftchild = aLeft; };
	KdNode *getLeftChild() { return leftchild; };
	setRightChild(KdNode *aRight) { rightchild = aRight; };
	KdNode *getRightChild() { return rightchild; };

	addShape(Shape* aShape) { shapes.push_back(aShape); };
};

class KdTree: public SpaceDivider
{
	KdNote *root;
public:
	KdTree(ShapeList &shapelist);
	rebuild();
};

#endif
