#!/usr/bin/python

import sys
sys.path.append(open('ModulePath').read().strip())

from raytracer import Raytracer, Material, Box, Sphere, Light
#, SphericalLight
import Image

rt = Raytracer()

light1 = Light(position=(0.0, 5.0, -3.0), colour=(0.9, 0.3, 0.6))
rt.addlight(light1)

#light2 = SphericalLight(position=(-2.0, 5.0, 1.0), radius=3.0, colour=(0.7, 1.0, 0.3))
light2 = Light(position=(-2.0, -5.0, -1.0), colour=(0.7, 1.0, 0.3))
rt.addlight(light2)

mat0 = Material(colour=(0.1, 0.2, 0.9))
box = Box(L=(-20.0, -1.2, -20.0), H=(20.0, -1.0, 20.0), material=mat0)
rt.addshape(box)

mat1 = Material(colour=(1.0, 0.2, 0.1))
bigsphere = Sphere(centre=(2.0, 2.0, -5.0), radius=2.5, material=mat1)
#      reflection=0.6)
rt.addshape(bigsphere)

mat2 = Material(colour=(0.1, 0.7, 1.0))
smallsphere = Sphere(centre=(-5.5, 1.5, -8.0), radius=2.0, material=mat2)
#      reflection=1.0, diffuse=0.1)
rt.addshape(smallsphere)

mat3 = Material(colour=(0.9, 0.9, 0.1))
tinysphere = Sphere(centre=(-0.5, 0.0, -2.0), radius=0.5, material=mat3)
#      reflection=1.0, diffuse=0.1)
rt.addshape(tinysphere)

#for i in range(100):
#      sph=Sphere((-5.5+i/10.0, -0.5, 7.0), 2.0)
#      rt.addshape(sph)

rendersize = (800, 600)
data = rt.render(rendersize)
img = Image.fromstring("RGB", rendersize, data)
img.save('demo.png')
