/* This code is part of RGB Image Library
   see URL: xxx */

/**************************************************************************

RGB Image Library (rgbimagelib)
File: image.c

Copyright (c) 2006 Radek Brich

Permission is hereby granted, free of charge, to any person
obtaining a copy of this software and associated documentation
files (the "Software"), to deal in the Software without
restriction, including without limitation the rights to use,
copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following
conditions:

The above copyright notice and this permission notice shall be
included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

**************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <png.h>

#include "image.h"

int new_image(struct image **img, int width, int height, int pixelsize)
{
	*img = (struct image *) malloc(sizeof(struct image));
	(*img)->pixel_size = pixelsize;
	(*img)->width = width;
	(*img)->height = height;
	(*img)->data = (unsigned char *) malloc(width * height * pixelsize);
	return(0);
}

void destroy_image(struct image **img)
{
	free((*img)->data);
	free(*img);
	*img = NULL;
}

/* funkce pro ulozeni obrazku do PNG souboru (vyuziva knihovnu libpng) */
int save_png(const char *fname, struct image *img)
{
	int y; /* pomocna promenna pro pruchod radku obrazu */
	FILE *f;
	png_structp png;   /* PNG data */
	png_infop pnginfo; /* PNG info */
	unsigned char *data;

	if ((f = fopen(fname, "wb")) == NULL)
		return (0);

	png = png_create_write_struct(PNG_LIBPNG_VER_STRING, 0, 0, 0);
	if (!png) {
		fclose(f);
		return (0);
	}

	pnginfo = png_create_info_struct(png);
	if (!pnginfo) {
		fclose(f);
		png_destroy_write_struct(&png, 0);
		return (0);
	}

	if (setjmp(png_jmpbuf(png))) {
		fclose(f);
		png_destroy_info_struct(png, &pnginfo);
		png_destroy_write_struct(&png, &pnginfo);
		return (0);
	}

	/* predat knihovne PNG ukazatel na soubor */
	png_init_io(png, f);

	/* parametry PNG */
	png_set_compression_level(png, Z_BEST_COMPRESSION);
	png_set_IHDR(png, pnginfo, img->width, img->height, 8, PNG_COLOR_TYPE_RGB,
		PNG_INTERLACE_NONE, PNG_COMPRESSION_TYPE_DEFAULT,
		PNG_FILTER_TYPE_DEFAULT);
	png_set_sRGB(png, pnginfo, PNG_sRGB_INTENT_PERCEPTUAL);
	png_set_sRGB_gAMA_and_cHRM(png, pnginfo, PNG_INFO_sRGB);

	/* zapsat hlavicku */
	png_write_info(png, pnginfo);

	/* zapsat data */
	data = img->data;
	for (y = 0; y < img->height; y++, data += img->width * img->pixel_size)
		png_write_row(png, (png_byte *) data);

	/* ukoncit soubor a uvolnit pomocne struktury */
	png_write_end(png, pnginfo);
	png_destroy_info_struct(png, &pnginfo);
	png_destroy_write_struct(&png, 0);

	fclose(f);

	return (1);
}
