#!/usr/bin/python

import sys
sys.path.append(open('ModulePath').read().strip())

from raytracer import Raytracer, Light, Sphere, Triangle, Material
import Image

def LoadWavefrontObjFile(rt, mat, filename):
	vertices = []
	fp = file(filename)
	while True:
		ln = fp.readline()
		if ln == "":
			break;
		ln = ln.split()
		if ln[0] == "v":
			v = [1.5*float(x) for x in ln[1:4]]
			vertices.append(tuple(v))
		if ln[0] == "f":
			f = [vertices[int(x)-1] for x in ln[1:4]]
			face = Triangle(f[0], f[1], f[2], mat)
			rt.addshape(face)

rt = Raytracer()
mat = Material(colour=(0.9, 0.9, 0.9))
LoadWavefrontObjFile(rt, mat, "monkey.obj")

light = Light(position=(-5.0, 2.0, 8.0), colour=(0.9, 0.3, 0.6))
rt.addlight(light)

imagesize = (800, 600)
data = rt.render(imagesize)
img = Image.fromstring("RGB", imagesize, data)
img.save('triangles_monkey.png')
