/*
 * C++ RayTracer
 * file: raytracer.h
 *
 * Radek Brich, 2006
 */

#ifndef RAYTRACER_H
#define RAYTRACER_H

#include <vector>

#include "common.h"
#include "kdtree.h"
#include "scene.h"

using namespace std;

class Raytracer;
struct RenderrowData {
	Raytracer *rt;
	int w;
	Vector3 eye, dfix, dx;
#if OVERSAMPLING
	Vector3 dy;
#endif
	float *iter;
};

class Raytracer
{
	Container *top;
	Camera *camera;
	vector<Light*> lights;
	Colour bg_colour;
	int ao_samples;
	float ao_distance, ao_angle;
	int num_threads;

	Vector3 SphereDistribute(int i, int n, float extent, Vector3 &normal);
public:
	Raytracer(): top(NULL), camera(NULL), lights(), bg_colour(0.0, 0.0, 0.0),
		ao_samples(0), num_threads(4) {};
	void render(int w, int h, float *buffer);
	Colour raytrace(Ray &ray, int depth, Shape *origin_shape);
	void addshape(Shape *shape) { top->addShape(shape); };
	void addlight(Light *light);
	void setCamera(Camera *cam) { camera = cam; };
	void setTop(Container *atop) { top = atop; };
	Container *getTop() { return top; };

	void ambientocclusion(int samples, float distance, float angle);
	void setThreads(int num) { num_threads = num; };
};

#endif
