#include <xmmintrin.h>
#include "vector.h"

int main() {
	{
	/* Vector */
	Vector a(1, 2, 3);
	cout << "=== Vector test ===" << endl;
	cout << "a = " << a << endl;
	Vector b(2, 3, 2);
	cout << "b = " << b << endl;

	cout << "a + b = " << a + b << endl;
	cout << "b - a = " << b - a << endl;
	cout << "dot(a,b) = " << dot(a,b) << endl;
	cout << "cross(a,b) = " << cross(a,b) << endl;
	cout << "a * 2 = " << a * 2 << endl;
	cout << "3 * b = " << 3 * b << endl;
	cout << "-a = " << -a << endl;

	cout << "a.mag() = " << a.mag() << endl;
	cout << "normalize(a) = " << normalize(a) << endl;
	cout << "normalize(a).mag() = " << normalize(a).mag() << endl;
	}

	{
	/* VectorPacket */
	VectorPacket a(_mm_set_ps(4,3,2,1), _mm_set_ps(8,7,6,5), _mm_set_ps(12,11,10,9));
	VectorPacket b(_mm_set_ps(41,31,21,11), _mm_set_ps(42,32,22,12), _mm_set_ps(43,33,23,13));
	cout << "=== VectorPacket test ===" << endl;
	cout << "a = " << a << endl;
	cout << "b = " << b << endl;

	cout << "a + b = " << a + b << endl;
	cout << "b - a = " << b - a << endl;
/*	cout << "dot(a,b) = " << dot(a,b) << endl;
	cout << "cross(a,b) = " << cross(a,b) << endl;
	cout << "a * 2 = " << a * 2 << endl;
	cout << "3 * b = " << 3 * b << endl;
	cout << "-a = " << -a << endl;

	cout << "normalize(a) = " << normalize(a) << endl;*/
	}

	return 0;
}
