#!/usr/bin/python

# this demo needs dragon model from
# http://graphics.stanford.edu/data/3Dscanrep/

import sys
sys.path.append(open('ModulePath').read().strip())

from raytracer import Raytracer, Light, Sphere, Triangle, Material
from plyreader import LoadStanfordPlyFile
import Image

rt = Raytracer()
mat = Material(colour=(0.9, 0.9, 0.9))
LoadStanfordPlyFile(rt, "../models/dragon/dragon_vrip_res2.ply",
	mat, smooth=True, scale=(-29.0, 29.0, -29.0), trans=(0.0, -3.6, 0.0))

light1 = Light(position=(-5.0, 2.0, 8.0), colour=(0.9, 0.3, 0.2))
rt.addlight(light1)

light2 = Light(position=(3.0, 0.0, 9.0), colour=(0.0, 1.0, 0.2))
rt.addlight(light2)

imagesize = (800, 600)
data = rt.render(imagesize)
img = Image.fromstring("RGB", imagesize, data)
img.save('dragon.png')
