#include "raytracer.h"
#include "kdtree.h"
#include "serialize.h"

#include "common_sdl.h"
#include "common_ply.h"

int main(int argc, char **argv)
{
	Raytracer rt;
	KdTree top;
	Camera cam;

	rt.setMaxDepth(0);
	rt.setTop(&top);
	rt.setCamera(&cam);
	cam.setEye(Vector3(0,0,10));

	Light light1(Vector3(-5.0, 2.0, 8.0), Colour(0.9, 0.3, 0.6));
	light1.castShadows(false);
	rt.addLight(&light1);

	//Light light2(Vector3(-2.0, 10.0, 2.0), Colour(0.4, 0.6, 0.3));
	//light2.castShadows(false);
	//rt.addlight(&light2);

	Material mat(Colour(0.9, 0.9, 0.9));
	mat.setSmooth(true);
	LinearColourMap cmap(Colour(0.5, 0.0, 0.0), Colour(1.0, 1.0, 0.5));
	//LinearColourMap cmap(Colour(1.0, 0.2, 0.0), Colour(0.3, 0.9, 0.2));
	mat.setTexture(new CloudTexture(10, &cmap));

	ifstream fin("realtime_dragon.kdtreedump");
	if (!fin)
	{
		load_ply(rt, "../models/ply/dragon/dragon_vrip.ply",
			&mat, Vector3(-29,29,-29), Vector3(0,-3.6,0));
		top.optimize();
	}
	else
		top.load(fin, &mat);

	for (int i = 1; i < argc; i++)
	{
		if (strcmp(argv[1], "-dump") == 0)
		{
			resetSerializer();
			ofstream fout("realtime_dragon.kdtreedump");
			fout << top << endl;
			fout.close();
		}

		if (strcmp(argv[1], "-buildonly") == 0)
			return 0;
	}

	loop_sdl(rt, cam);
}
