#!/usr/bin/python

import sys
sys.path.append("..")

from raytracer import Raytracer, Material, Plane, Sphere, Light
import Image

rt = Raytracer()

light1 = Light(position=(0.0, 5.0, 5.0), colour=(0.7, 0.3, 0.6))
rt.addlight(light1)

light2 = Light(position=(-2.0, 10.0, 2.0), colour=(0.4, 0.6, 0.3))
rt.addlight(light2)

mat0 = Material(colour=(0.7, 0.7, 0.7))

plane = Plane(normal=(0.0, 1.0, 0.0), d=1.0, material=mat0)
rt.addshape(plane)

mat1 = Material(colour=(1.0, 0.0, 0.0))
bigsphere = Sphere(centre=(3.0, 2.0, 7.0), radius=3.0, material=mat1)
rt.addshape(bigsphere)

mat2 = Material(colour=(0.0, 1.0, 0.0))
smallsphere = Sphere(centre=(-5.5, 1.5, 8.0), radius=2.0, material=mat2)
rt.addshape(smallsphere)

mat3 = Material(colour=(0.0, 0.0, 1.0))
tinysphere = Sphere(centre=(-1.2, 0.0, 2.0), radius=0.5, material=mat3)
rt.addshape(tinysphere)

imagesize = (800, 600)
data = rt.render(imagesize)
img = Image.fromstring("RGB", imagesize, data)
img.save('spheres_shadow.png')
