/*
 * Pyrit Ray Tracer
 * file: container.cc
 *
 * Radek Brich, 2006-2007
 */

#include "common.h"
#include "container.h"

void Container::addShape(Shape* aShape)
{
	shapes.push_back(aShape);
	if (shapes.size() == 0) {
		/* initialize bounding box */
		bbox = aShape->get_bbox();
	} else {
		/* adjust bounding box */
		BBox shapebb = aShape->get_bbox();
		if (shapebb.L.x < bbox.L.x)  bbox.L.x = shapebb.L.x;
		if (shapebb.L.y < bbox.L.y)  bbox.L.y = shapebb.L.y;
		if (shapebb.L.z < bbox.L.z)  bbox.L.z = shapebb.L.z;
		if (shapebb.H.x > bbox.H.x)  bbox.H.x = shapebb.H.x;
		if (shapebb.H.y > bbox.H.y)  bbox.H.y = shapebb.H.y;
		if (shapebb.H.z > bbox.H.z)  bbox.H.z = shapebb.H.z;
	}
};

Shape *Container::nearest_intersection(const Shape *origin_shape, const Ray &ray,
        Float &nearest_distance)
{
	Shape *nearest_shape = NULL;
	ShapeList::iterator shape;
	for (shape = shapes.begin(); shape != shapes.end(); shape++)
		if (*shape != origin_shape && (*shape)->intersect(ray, nearest_distance))
			nearest_shape = *shape;
	return nearest_shape;
}
