/*
 * Pyrit Ray Tracer
 * file: matrix.h
 *
 * Radek Brich, 2006-2007
 */

/* not used at this time */

#ifndef MATRIX_H
#define MATRIX_H

#include "vector.h"

using namespace std;

class Matrix
{
public:
	Float data[4][4];

	Matrix(): {};

	// sum
	friend Matrix operator+(const Matrix &a, const Matrix &b)
	{
		Matrix m = Matrix();
		for (int i = 0; i < 4; i++)
			for (int j = 0; j < 4; j++)
				m.data[i][j] = a.data[i][j] + b.data[i][j];
		return m;
	}

	// difference
	friend Matrix operator-(const Matrix &a, const Matrix &b)
	{
		Matrix m = Matrix();
		for (int i = 0; i < 4; i++)
			for (int j = 0; j < 4; j++)
				m.data[i][j] = a.data[i][j] - b.data[i][j];
		return m;
	}

	// product
	friend Matrix operator*(const Matrix &a, const Matrix &b)
	{
		Matrix m = Matrix();
		for (int i = 0; i < 4; i++)
			for (int j = 0; j < 4; j++)
				m.data[i][j] =
					a.data[i][0] * b.data[0][j] +
					a.data[i][1] * b.data[1][j] +
					a.data[i][2] * b.data[2][j] +
					a.data[i][3] * b.data[3][j];
		return m;
	}

	// negative
	Matrix operator-()
	{
		Matrix m = Matrix();
		for (int i = 0; i < 4; i++)
			for (int j = 0; j < 4; j++)
				m.data[i][j] = -data[i][j];
		return m;
	}

	// product of matrix and scalar
	Matrix operator*(const Float &f)
	{
		Matrix m = Matrix();
		for (int i = 0; i < 4; i++)
			for (int j = 0; j < 4; j++)
				m.data[i][j] = data[i][j] * f;
		return m;
	}

	friend Matrix operator*(const Float &f, Matrix &m) { return m * f; };

	// product of matrix and vector
	Vector3 operator*(const Vector3 &v)
	{
		Vector3 u = Vector3();
		u.x = data[0][0] * v.x + data[0][1] * v.y + data[0][2] * v.z + data[0][3] * v.w;
		u.y = data[1][0] * v.x + data[1][1] * v.y + data[1][2] * v.z + data[1][3] * v.w;
		u.z = data[2][0] * v.x + data[2][1] * v.y + data[2][2] * v.z + data[2][3] * v.w;
		u.w = data[3][0] * v.x + data[3][1] * v.y + data[3][2] * v.z + data[3][3] * v.w;
		return u;
	}

	friend Matrix operator*(const Vector3 &v, Matrix &m) { return m * v; };
};

#endif
