#!/usr/bin/python

from pyrit import *
from objreader import LoadWavefrontObjFile

rt = Raytracer()
top = KdTree()
rt.setTop(top)
rt.setCamera(Camera(eye=(0,0,6)))

light1 = Light(position=(0.0, 2.0, 6.0), colour=(0.9, 0.3, 0.6))
light1.castShadows(False);
rt.addLight(light1)

light2 = Light(position=(-2.0, -5.0, 7.0), colour=(0.7, 1.0, 0.3))
light2.castShadows(False);
rt.addLight(light2)

mat = Material(colour=(0.9, 0.9, 0.9))
LoadWavefrontObjFile(rt, "../models/obj/sphere.obj", mat, 1.5)
top.optimize()

sampler = DefaultSampler(800, 600)
rt.setSampler(sampler)
rt.render()
sampler.getPixmap().writePNG('triangles_sphere.png')
