#!/usr/bin/env python3

import sys
sys.path.append('..')

from tuikit.treeview import *
import unittest


class TestTreeView(unittest.TestCase):
    def test_treemodel(self):
        '''Build tree model, iterate through the tree, test result.'''
        # build tree model
        # root
        # ├ a
        # │ ├ c
        # │ └ d
        # │   ├ e
        # │   │ └ g
        # │   └ f
        # │     └ h
        # └ b
        model = TreeModel()
        model.add('/',  ['a', 'b'])
        model.add('/a', ['c', 'd'])
        model.add((0,1), ['e', 'f'])
        model.add('/0/1/0', 'g')
        model.add('/a/d/f', 'h')
        
        res = ''
        for l, i, c, n in model:
            res += str(l) + str(i) + str(c) + n.name
            
        self.assertEqual(res, '112a212c222d312e411g322f411h122b')


if __name__ == '__main__':
    unittest.main()

