#!/usr/bin/env python3

import demobase

from tuikit.layouts.grid import GridLayout
from tuikit.widgets.label import Label

l1 = Label('Hello')
l1.sizemin.update(10, 1)

grid = GridLayout()
grid.add(l1, 1, 1)
grid.update(10, 10)

print(grid._grid_size)
print(grid._grid)

for row in range(grid.row_count):
    for col in range(grid.column_count):
        w = grid.get_widget_at(row, col)
        name = w.name if w else '--'
        print(name.center(16), end='')
    print()

print(l1.pos)
print(l1.size)