#!/usr/bin/env python3
# -*- coding: utf-8 -*-

import sys
sys.path.append('..')

from tuikit.events import Emitter, KeyboardEvent

class A(Emitter):
    def __init__(self):
        self.add_events('keypress', KeyboardEvent)

    def on_keypress(self, ev):
        """A"""
        print('A on', ev.keyname, self)

    def after_keypress(self, ev):
        """A"""
        print('A after', ev.keyname, self)


class B(A):
    def __init__(self):
        super().__init__()

    def on_keypress(self, ev):
        """B"""
        print('B on', ev.keyname, self)
        #return True

    def after_keypress(self, ev):
        """B"""
        print('B after', ev.keyname, self)


class C(B):
    def __init__(self):
        super().__init__()


def on_keypress(ev):
    """global"""
    print('global on', ev.keyname)


def after_keypress(ev):
    """global"""
    print('global after', ev.keyname)


if __name__ == '__main__':
    c = C()
    c.add_handler('keypress', after_keypress, last=True)
    c.add_handler('keypress', on_keypress)

    for x in c._event_handlers['keypress']:
        print(x, x.__doc__)

    print()
    c.emit('keypress', keyname='XKey', char=None)

