# distutils: language = c++
# distutils: sources = src/sdlterm.cc
# distutils: include_dirs = /usr/include/SDL src
# distutils: libraries = SDL SDL_ttf
# distutils: define_macros = _GNU_SOURCE=1 _REENTRANT
# distutils: extra_compile_args = --std=c++0x
# cython: language_level=3

from libcpp cimport bool


cdef extern from "sdlterm.h":
    enum EventType:
        pass

    union Event:
        EventType type

    cdef cppclass Terminal:
        Terminal() except +

        void select_font(char *fname_regular, char *fname_bold, int ptsize)
        void resize(int pxwidth, int pxheight)

        void erase()
        void putch(int x, int y, Py_UNICODE ch)
        void commit()

        int prepare_attr(int fg, int bg, int style)
        void set_attr(int value)

        void set_cursor(int x, int y)
        void show_cursor(bool visible)

        void get_next_event(Event event)


cdef class SDLTerminal:
    cdef Terminal *thisptr      # hold a C++ instance which we're wrapping

    def __cinit__(self):
        self.thisptr = new Terminal()
    def __dealloc__(self):
        del self.thisptr

    def select_font(self, fname_regular, fname_bold, ptsize):
        fname_regular = fname_regular.encode('utf8')
        fname_bold = fname_bold.encode('utf8')
        self.thisptr.select_font(fname_regular, fname_bold, ptsize)
    def resize(self, width, height):
        self.thisptr.resize(width, height)

    def erase(self):
        self.thisptr.erase()
    def putch(self, x, y, ch):
        self.thisptr.putch(x, y, ch)
    def commit(self):
        self.thisptr.commit()

    def get_next_event(self):
        cdef Event event
        self.thisptr.get_next_event(event)
        return dict()

