#!/usr/bin/env python3

import sys
sys.path.insert(0, '..')

from tuikit.treeview import *
import unittest


class TestTreeView(unittest.TestCase):
    def setUp(self):
        """Build tree model

        # root
        # ├ a
        # │ ├ c
        # │ └ d
        # │   ├ e
        # │   │ └ g
        # │   └ f
        # │     └ h
        # └ b

        """
        self.model = TreeModel()
        self.model.add('/',  ['a', 'b'])
        self.model.add('/a', [TreeNode('c'), TreeNode('d')])
        self.model.add((0,1), ['e', TreeNode('f')])
        self.model.add([0,1,0], 'g')
        self.model.add('/a/d/f', TreeNode('h'))

    def test_treeiter(self):
        """Iterate through the tree, test result."""
        res = ''
        for l, i, c, n in self.model:
            res += str(l) + str(i) + str(c) + n.name

        self.assertEqual(res, '112a212c222d312e411g322f411h122b')

    def test_treemodel_find(self):
        # good path
        node = self.model.find('/a/d/f/h')
        self.assertEqual(node.name, 'h')
        self.assertEqual(node.path, '/a/d/f/h')
        # bad path
        self.assertRaises(ValueError, self.model.find, '/a/b/c')
        self.assertRaises(IndexError, self.model.find, [0,1,3])

if __name__ == '__main__':
    unittest.main()

