#!/usr/bin/env python3
# -*- coding: utf-8 -*-

import locale
locale.setlocale(locale.LC_ALL, '')

from tuikit import *


class MyApplication(Application):
    def __init__(self):
        Application.__init__(self)
        self.top.connect('keypress', self.globalkeypress)

        self.text = ''
        textedit = TextEdit(100, 40, self.text)
        self.top.add(textedit)
        textedit.x = 2
        self.textedit = textedit


    def globalkeypress(self, keyname, char):
        if char == 'q':
            self.terminate()
        self.text += 'keyname: %s  char: %s\n' % (keyname, char)
        self.textedit.settext(self.text)
        self.textedit.scrolltoend()


if __name__ == '__main__':
    app = MyApplication()
    app.start()

