#!/usr/bin/python3

import curses
import locale

locale.setlocale(locale.LC_ALL,"")

def doStuff(screen):
    screen.addstr('%s\n' % curses.termname())
    screen.keypad(1)
    screen.scrollok(1)
    curses.nl()
    curses.mousemask(curses.ALL_MOUSE_EVENTS | curses.REPORT_MOUSE_POSITION)
    curses.mouseinterval(0)  # do not wait to detect clicks, we use only press/release
    while True:
        c = screen.getch()
        char = ' '
        if c < 256:
            char = curses.unctrl(c)
        screen.addstr('key: %x %s\n' % (c, char))

        if c == curses.KEY_MOUSE:
            id_, x, y, z, bstate = curses.getmouse()
            screen.addstr('(%d %d %d %d %s)\n' % (id_, x, y, z, bin(bstate)))

        screen.refresh()

curses.wrapper(doStuff)
