from tuikit.core.widget import Widget


class Label(Widget):

    def __init__(self, label=''):
        Widget.__init__(self)
        self.sizereq.update(len(label), 1)
        self.label = label
        self.color = 'default'

    def set_theme(self, theme):
        self.color = self.theme.normal

    def draw(self, buffer):
        with buffer.attr(self.color):
            buffer.puts(self.label)
