#!/usr/bin/env python3

import sys
sys.path.append('..')

from tuikit.core.buffer import Buffer
from tuikit.driver.curses import CursesDriver


colors = ('blue', 'green', 'cyan', 'red',
          'magenta', 'brown', 'lightgray', 'gray',
          'lightblue', 'lightgreen', 'lightcyan', 'lightred',
          'lightmagenta', 'yellow', 'white')

buffer = Buffer(16, 8)
buffer.fill(c='#')
buffer.hline(1, 1, 14, c='-')
buffer.hline(1, 6, 14, c='-')
buffer.vline(7, 2, 4, c='|')
buffer.puts(8, 4, 'Hello!')
buffer.frame()

buffer2 = Buffer(30, 10)
buffer2.setattr('white on black')
buffer2.frame()

for idx, color in enumerate(colors):
    buffer2.setattr(color)
    buffer2.puts(3 + 12 * (idx // 8), 1 + idx % 8, color)

buffer3 = Buffer(30, 10)
buffer3.setattr('white on black')
buffer3.frame()

for idx, color in enumerate(colors[:8]):
    buffer3.setattr('black on {}'.format(color))
    buffer3.puts(2, 1 + idx, ' '+color.ljust(10))
    buffer3.setattr('{}, underline, bold'.format(color))
    buffer3.puts(15, 1 + idx, ' '+color.ljust(10))

buffer3.setattr('lightgray, blink')
buffer3.puts(3, 8, 'blink')

driver = CursesDriver()
with driver:
    driver.draw(buffer)
    driver.draw(buffer2, 20, 00)
    driver.draw(buffer3, 20, 10)
    driver.flush()
    driver.getevents()
