#include "sdlterm.h"


class Application
{
public:
    Terminal term;
    bool done;

    Application() : term(), done(false) {};

    void init();
    void wait_and_process_event();
};


void Application::init()
{
    term.resize(800, 600);
    term.select_font("font/DejaVuSansMono.ttf", "font/DejaVuSansMono-Bold.ttf", 12);
    term.erase();

    char hello[] = "Hello World!";
    for (int bg = 0; bg < 16; bg++)
    {
        for (int fg = 0; fg < 16; fg++)
        {
            for (char *c = hello; *c; c++)
            {
                term.set_attr( term.prepare_attr(fg, bg, 1) );
                term.putch(5 + 6 * bg + (c - hello), 5 + fg, *c);
            }
        }
    }
    term.commit();
}


void Application::wait_and_process_event()
{
    Event event;
    term.get_next_event(event);

    switch (event.type)
    {
        case Event::QUIT:
            done = true;
            break;

        default:
            break;
    }
}


int main(int argc, char *argv[])
{
    Application app;
    app.init();

    while (!app.done)
    {
        app.wait_and_process_event();
    }

    return 0;
}

