#!/usr/bin/env python3

from tuikit.core.buffer import Buffer
from tuikit.driver.cursesw import CursesWDriver

buffer = Buffer()
line = 0
with CursesWDriver() as driver:
    buffer.resize(*driver.size)
    buffer.puts(str(driver.size), 0, 10)
    while True:
        for event in driver.getevents():
            buffer.puts(str(event), 0, line)
            line += 1
        driver.draw(buffer)
        driver.flush()
        if line >= buffer.size.h:
            buffer.fill()
            line = 0
