#!/usr/bin/env python3

import demobase

from tuikit.core.application import Application
from tuikit.widgets.label import Label
from tuikit.widgets.button import Button
from tuikit.widgets.textfield import TextField

label = Label('Hello there!')
label.posreq.update(20, 10)

button1 = Button()
button1.posreq.update(20, 20)
button2 = Button()
button2.posreq.update(30, 20)

field = TextField('text field')
field.posreq.update(20, 30)

app = Application()
app.root_window.add(label)
app.root_window.add(button1)
app.root_window.add(button2)
app.root_window.add(field)
app.root_window.focus_widget = field

def on_keypress(ev):
    if ev.keyname == 'escape':
        app.stop()

app.window_manager.sig_keypress.connect(on_keypress)

app.start()

