#!/usr/bin/env python3
# -*- coding: utf-8 -*-

import pygame

pygame.init()

font = pygame.font.SysFont('dejavusansmono', 14)

print('Size: %s %s' % font.size('Q'))
print('Linesize: %s' % font.get_linesize())
print('Height: %s' % font.get_height())
print('Ascent: %s' % font.get_ascent())
print('Descent: %s' % font.get_descent())

chars = '┌─┐└─┘│'
metrics = font.metrics(chars)
print('metrics=(minx, maxx, miny, maxy, advance)')

for c, m in zip(chars, metrics):
    s = font.size(c)
    surface = font.render(c, False, (255,255,255), (0,0,0))
    ss = surface.get_size()
    ssg = None
    if hasattr(font, 'render_glyph'):
        surface_glyph = font.render_glyph(c, False, (255,255,255), (0,0,0))
        ssg = surface_glyph.get_size()
    print('%s metrics=%s size=%s surface_size=%s glyph_size=%s' % (c, m, s, ss, ssg))

