#!/usr/bin/env python3
# -*- coding: utf-8 -*-

from tuikit import *

# -------------
# | 0 | 1 | 2 |
# -------------
# | 3     | 4 |
# -------------
# | 5         |
# -------------
#
# 3 - colspan = 2
# 5 - autospan

if __name__ == '__main__':
    cont = Container()

    w = [None] * 6
    for i in range(6):
        w[i] = Widget()
        cont.add(w[i])

    w[3].layouthints['colspan'] = 2

    w[1].sizemin = (2,2)
    w[3].sizemin = (6,1)

    grid = GridLayout(3)
    grid.container = cont

    print('* _fillgrid')
    grid._fillgrid()

    print('span:')
    for row in grid._grid:
        for col in row:
            print('[%s,%d,%d]' % (
                col['widget'].__class__.__name__[0],
                col['colspan'],
                col['rowspan']), end=' ')
        print()

    print('* _computesizes')
    grid._computesizes()

    print('sizemin:')
    for row in grid._grid:
        for col in row:
            w = col['widget']
            if w is None:
                print('[0,0]', end=' ')
            else:
                print('[%d,%d]' % w.sizemin, end=' ')
        print()

    print('colminw:')
    print(grid._colminw)

    print('rowminh:')
    print(grid._rowminh)
