#!/usr/bin/env python3
# -*- coding: utf-8 -*-

import sys
sys.path.append('..')

from tuikit import Container, Widget, Size, GridLayout

# +---+---+---+
# | 0     | 1 |
# +---+---+   +
# | 2 | 3 |   |
# +---+   +   +
# | 4 |   |   |
# +---+---+---+
#
# 0 - colspan = 2
# 1 - rowspan = 3
# 3 - rowspan = 2

if __name__ == '__main__':
    cont = Container()

    w = [None] * 6
    for i in range(6):
        w[i] = Widget()
        cont.add(w[i])

    w[0].hints['colspan'] = 2

    w[1].sizemin = Size(2,2)
    w[3].sizemin = Size(6,1)

    grid = GridLayout(3)
    grid.container = cont

    print('* _fillgrid')
    grid._fillgrid()

    print('span:')
    for row in grid._grid:
        for col in row:
            print('[%s,%d,%d]' % (
                col['widget'].__class__.__name__[0],
                col['colspan'],
                col['rowspan']), end=' ')
        print()

    print('* _computesizes')
    grid._computesizes()

    print('sizemin:')
    for row in grid._grid:
        for col in row:
            w = col['widget']
            if w is None:
                print('[0,0]', end=' ')
            else:
                print('[{0.w},{0.h}]'.format(w.sizemin), end=' ')
        print()

    print('colminw:')
    print(grid._colminw)

    print('rowminh:')
    print(grid._rowminh)

