#!/usr/bin/env python3

from tuikit.core.application import Application
from tuikit.widgets.label import Label
from tuikit.widgets.button import Button
from tuikit.widgets.textfield import TextField

label = Label('Hello there!')
button1 = Button()
button2 = Button()
field = TextField('text field')

app = Application()
app.root_window.add(label, 20, 10)
app.root_window.add(button1, 20, 20)
app.root_window.add(button2, 30, 20)
app.root_window.add(field, 20, 30)
app.root_window.focus_widget = field

def on_keypress(ev):
    if ev.keyname == 'escape':
        app.stop()

app.window_manager.sig_keypress.connect(on_keypress)

app.start()

