# Set system locale (needed for ncurses)
import locale
locale.setlocale(locale.LC_ALL, '')

# Setup logging
import logging
logger = logging.getLogger('tuikit')
logger.setLevel(logging.DEBUG)
handler = logging.FileHandler(filename='tuikit.log')
handler.setLevel(logging.DEBUG)
formatter = logging.Formatter('%(asctime)s %(name)s %(levelname)s %(message)s')
handler.setFormatter(formatter)
logger.addHandler(handler)

# Escape key code is also used for escape sequences. After escape code,
# terminal waits for rest of sequence. This delay is 1 second by default.
# Let's hope that our terminal is fast enough to handle the sequences in 200ms.
import os
os.environ['ESCDELAY'] = '200'

def setup():
    pass
