#!/usr/bin/env python3

from tuikit.core.buffer import Buffer
from tuikit.driver.cursesw import CursesWDriver

buffer = Buffer()
with CursesWDriver() as driver:
    buffer.resize(*driver.size)
    buffer.puts("Press a key or mouse button. Ctrl-C to exit.", 0, 0)
    line = 1
    while True:
        driver.draw(buffer)
        driver.flush()
        if line >= buffer.size.h:
            buffer.fill()
            line = 0
        for event in driver.getevents():
            buffer.puts(str(event), 0, line)
            line += 1
