#!/usr/bin/env python3

import sys
sys.path.append('..')

from tuikit.core.buffer import Buffer
from tuikit.driver.curses import CursesDriver


buffer = Buffer(16, 8)
buffer.fill(c='#')
buffer.hline(1, 1, 14, c='-')
buffer.hline(1, 6, 14, c='-')
buffer.vline(7, 2, 4, c='|')
buffer.puts(8, 4, 'Hello!')
buffer.frame()

driver = CursesDriver()
with driver:
    driver.draw(buffer)
    driver.draw(buffer, 20, 10)
    driver.stdscr.refresh()
    driver.stdscr.getch()

