# -*- coding: utf-8 -*-

from tuikit.container import Container
from tuikit.editbox import EditBox
from tuikit.scrollbar import VScrollbar


class TextEdit(Container):
    def __init__(self, width=20, height=20, text=''):
        Container.__init__(self, width, height)

        self.editbox = EditBox(width-2, height-2, text)
        self.add(self.editbox)
        self.editbox.x = 1
        self.editbox.y = 1
        self.editbox.connect('scroll', self.on_editbox_scroll)
        self.editbox.connect('areasize', self.on_editbox_areasize)

        self.vscroll = VScrollbar(height - 2)
        self.add(self.vscroll)
        self.vscroll.x = width - 1
        self.vscroll.y = 1
        self.vscroll.connect('change', self.on_vscroll_change)

        self.on_editbox_areasize()

        self.connect('draw', self.on_draw)


    def settext(self, text):
        self.editbox.set_text(text)


    def scrolltoend(self):
        self.editbox.move_pagelast()


    def on_draw(self, screen, x, y):
        screen.frame(x, y, self.width, self.height)


    def on_editbox_scroll(self):
        self.vscroll.setpos(self.editbox.yofs)


    def on_editbox_areasize(self):
        smax = len(self.editbox.lines) - self.editbox.height
        if smax < 0:
            smax = 0
        self.vscroll.max = smax


    def on_vscroll_change(self):
        self.editbox.yofs = self.vscroll.pos
        self.editbox.redraw()

