# -*- coding: utf-8 -*-

import logging

from tuikit.container import Container
from tuikit.layout import VerticalLayout, HorizontalLayout
from tuikit.button import Button


class Pager(Container):
    '''Only one of children is visible at the time.'''
    def __init__(self, width=20, height=20):
        Container.__init__(self, width, height)

        # selected child (only one visible)
        self.selected = None
        
        vert = VerticalLayout()
        self.layout(vert)
        
        self.buttons = Container(20, 1)
        self.buttons.sizereq.h = 1
        Container.add(self, self.buttons)
        horz = HorizontalLayout(homogeneous=True, spacing=1)
        self.buttons.layout(horz)
                
    def add(self, widget, **kw):
        Container.add(self, widget, expand=True, fill=True)
        
        if self.selected is None:
            self.selected = widget
            widget.hidden = False
        else:
            widget.hidden = True
        
        btn = Button(kw['title'])
        btn.connect('click', lambda: self.select(widget))
        self.buttons.add(btn, fill=True)

    def select(self, child):
        log = logging.getLogger('tuikit')
        log.debug('Pager: select %r', child)

        self.selected.hidden = True
        child.hidden = False
        self.selected = child

        self.resize()

