# -*- coding: utf-8 -*-
'''Tuikit driver base.'''

from tuikit.common import Size, ClipStack, UnicodeGraphics


class Driver:
    
    '''Abstract driver interface. Use as base for drivers.'''
    
    def __init__(self):
        '''Initialize instance attributes.'''
        self.size = Size()
        '''Screen size.'''
        self.clipstack = ClipStack()
        '''Clipping region stack.'''
        self.unigraph = UnicodeGraphics()
        '''Unicode graphics characters.'''


    # drawing
    
    def puts(self, x, y, s):
        '''Output string of characters.'''
        for c in s:
            self.putch(x, y, c)
            x += 1

    def hline(self, x, y, w, c=' '):
        '''Draw horizontal line.'''
        if isinstance(c, str):
            s = c*w
        else:
            s = [c]*w
        self.puts(x, y, s)

    def vline(self, x, y, h, c=' '):
        '''Draw vertical line.'''
        for i in range(h):
            self.putch(x, y+i, c)

    def fill(self, x, y, w, h, c=' '):
        '''Fill rectangular area.'''
        for i in range(h):
            self.hline(x, y + i, w, c)

    def frame(self, x, y, w, h):
        '''Draw rectangular frame using line-drawing characters.'''
        self.putch(x, y, self.unigraph.ULCORNER)
        self.putch(x+w-1, y, self.unigraph.URCORNER)
        self.putch(x, y+h-1, self.unigraph.LLCORNER)
        self.putch(x+w-1, y+h-1, self.unigraph.LRCORNER)
        self.hline(x+1, y, w-2, self.unigraph.HLINE)
        self.hline(x+1, y+h-1, w-2, self.unigraph.HLINE)
        self.vline(x, y+1, h-2, self.unigraph.VLINE)
        self.vline(x+w-1, y+1, h-2, self.unigraph.VLINE)

    