# -*- coding: utf-8 -*-

from tuikit.widget import Widget
import logging


class MenuBar(Widget):
    def __init__(self, items = []):
        Widget.__init__(self, 0, 1)

        self.bg = 'menu'
        self.highlight = 'menu-active'

        self.setitems(items)
        self.selected = None

        self.connect('draw', self.on_draw)
        self.connect('keypress', self.on_keypress)
        self.connect('mousedown', self.on_mousedown)
        self.connect('mousemove', self.on_mousemove)
        self.connect('unfocus', self.on_unfocus)


    def setitems(self, items):
        self.items = items

        i = 0
        for item in self.items:
            if isinstance(item[1], Widget):
                item[1].x = i
                item[1].y = self.y + 1
                item[1].allowlayout = False
                item[1].hidden = True
                item[1].connect('focus', self.on_submenu_focus)
                item[1].menubar = self
            i += len(item[0]) + 4


    def on_draw(self, screen, x, y):
        screen.pushcolor(self.bg)
        i = 0
        for item in self.items:
            if self.selected == item:
                screen.pushcolor(self.highlight)
                screen.puts(x + i, y, '  ' + item[0] + '  ')
                screen.popcolor()
            else:
                screen.puts(x + i, y, '  ' + item[0] + '  ')
            i += len(item[0]) + 4
        if i < self.width:
            screen.puts(x + i, y, ' ' * (self.width - i))
        screen.popcolor()


    def on_keypress(self, keyname, char):
        if keyname == 'left':
            self.move_selected(-1)
        elif keyname == 'right':
            self.move_selected(+1)
        else:
            if self.selected:
                if isinstance(self.selected[1], Widget):
                    self.selected[1].emit('keypress', keyname, char)


    def move_selected(self, offset):
        if self.selected:
            i = self.items.index(self.selected)
            item = self.items[(i + offset) % len(self.items)]
            self.unselect()
            self.select(item)
        self.redraw()


    def on_mousedown(self, ev):
        i = 0
        self.unselect()
        for item in self.items:
            w = len(item[0]) + 4
            if ev.wx >= i and ev.wx < i + w:
                self.select(item)
            i += w


    def on_mousemove(self, ev):
        self.on_mousedown(ev)


    def on_unfocus(self, newfocus):
        #logging.getLogger('tuikit').debug('unfocus')
        if self.selected and newfocus == self.selected[1]:
            return
        self.unselect()


    def on_submenu_focus(self):
        self.setfocus()


    def select(self, item):
        self.selected = item
        if isinstance(item[1], Widget):
            item[1].hidden = False
            item[1].redraw()


    def unselect(self):
        if self.selected:
            if isinstance(self.selected[1], Widget):
                self.selected[1].hidden = True
            self.selected = None

