# -*- coding: utf-8 -*-

from tuikit.container import Container
from tuikit.editfield import EditField
from tuikit.button import Button
from tuikit.menu import Menu


class ComboBox(Container):
    def __init__(self, width=15, value='', items=[]):
        Container.__init__(self, width, 1)
        
        self._edit = EditField(width - 3, value)
        self.add(self._edit)
        
        self._btn = Button('v')
        self._btn.x = width - 3
        self._btn.width = 3
        self._btn.connect('click', self._on_btn_click)
        self.add(self._edit)
        
        self._menu = Menu(items)
        self._menu.hide()
        self._menu.allowlayout = False
#        self.top.add(self._menu)
        
    
    def _on_btn_click(self):
        pass
    
    
