# -*- coding: utf-8 -*-
'''Dummy driver.

Implements basic driver interface.
This is useful for debugging or when writing new driver.

'''

import logging

from tuikit.driver import Driver


class DriverDummy(Driver):
    
    '''Dummy driver class'''
    
    def __init__(self):
        '''Initialize instance attributes'''
        Driver.__init__(self)
        self.log = logging.getLogger('tuikit')
        self.size.w, self.size.h = 80, 25
    
    def start(self, mainfunc):
        '''Start driver and run mainfunc.'''
        mainfunc()


    ## input ##
    
    def getevents(self, timeout=None):
        '''Process input, return list of events.
        
        This dummy implementation just returns 'q' and Escape key presses.
        
        '''
        events = [('keypress', None, 'q'), ('keypress', 'escape', None)]
        return events


    ## drawing ##
    
    def erase(self):
        '''Clear screen.'''
        self.log.info('DummyDriver.erase()')

    def putch(self, x, y, c):
        '''Output one unicode character to specified coordinates.'''
        self.log.info('DummyDriver.putch(x=%r, y=%r, c=%r)', x, y, c)

    def commit(self):
        '''Commit changes to the screen.'''
        self.log.info('DummyDriver.commit()')


    ## colors ##
    
    def setcolor(self, name, desc):
        '''Define color name.
        
        name - name of color (e.g. 'normal', 'active')
        desc - color description - foreground, background, attributes (e.g. 'black on white, bold')
        
        '''
        self.log.info('DummyDriver.setcolor(name=%r, desc=%r)', name, desc)

    def pushcolor(self, name):
        '''Add color on top of stack and use this color for following output.'''
        self.log.info('DummyDriver.pushcolor(name=%r)', name)
    
    def popcolor(self):
        '''Remove color from top of stack and use new top color for following output.'''
        self.log.info('DummyDriver.popcolor()')


    ## cursor ##

    def showcursor(self, x, y):
        '''Set cursor to be shown at x, y coordinates.'''
        self.log.info('DummyDriver.showcursor(x=%r, y=%r)', x, y)

    def hidecursor(self):
        '''Hide cursor.'''
        self.log.info('DummyDriver.hidecursor()')

