# -*- coding: utf-8 -*-

from tuikit.widget import Widget


class Menu(Widget):
    def __init__(self, items=[]):
        Widget.__init__(self)
        self.width = max([len(x[0]) for x in items if x is not None]) + 4
        self.height = len(items) + 2

        self.bg = 'menu'
        self.highlight = 'menu-active'
        self.items = items
        self.selected = items[0]
        self.menubar = None

        self.connect('draw', self.on_draw)
        self.connect('keypress', self.on_keypress)
        self.connect('mousedown', self.on_mousedown)
        self.connect('mousemove', self.on_mousemove)
        self.connect('mouseup', self.on_mouseup)
        
        self.addevents('activate')


    def on_draw(self, screen, x, y):
        screen.pushcolor(self.bg)
        screen.frame(x, y, self.width, self.height)
        i = 1
        for item in self.items:
            if item is None:
                screen.puts(x, y + i, screen.LTEE + screen.HLINE * (self.width - 2) + screen.RTEE)
            else:
                if self.selected == item:
                    screen.pushcolor(self.highlight)
                    screen.puts(x + 1, y + i, ' ' + item[0] + ' ' * (self.width - 3 - len(item[0])))
                    screen.popcolor()
                else:
                    screen.puts(x + 1, y + i, ' ' + item[0] + ' ' * (self.width - 3 - len(item[0])))
            i += 1
        screen.popcolor()


    def on_keypress(self, keyname, char):
        if keyname == 'up':
            self.move_selected(-1)
        if keyname == 'down':
            self.move_selected(+1)
        if keyname == 'enter':
            self.run_selected()
        self.redraw()


    def on_mousedown(self, ev):
        self.select_at_pos(ev.wy - 1)


    def on_mousemove(self, ev):
        self.select_at_pos(ev.wy - 1)


    def on_mouseup(self, ev):
        ok = self.select_at_pos(ev.wy - 1)
        if ok:
            self.run_selected()


    def select_at_pos(self, pos):
        if pos < 0:
            return False
        try:
            item = self.items[pos]
        except IndexError:
            return False
        if item is None:
            return False
        self.selected = item
        self.redraw()
        return True


    def move_selected(self, offset):
        if self.selected:
            i = self.items.index(self.selected)
            i += offset
            item = self.items[i % len(self.items)]
            if item is None:
                i += offset
                item = self.items[i % len(self.items)]
            self.selected = item
        self.redraw()


    def activate(self, name):
        self.handle('activate', name)


    def run_selected(self):
        if self.selected and self.selected[1] is not None:
            if isinstance(self.selected[1], str):
                self.emit('activate', self.selected[1])
            elif isinstance(self.selected[1], Widget):
                self.selected[1].show()
                self.selected[1].setfocus()
            else:
                self.menubar.resetfocus()
                self.selected[1]()

